#include <exec/resident.h>
#ifdef __MORPHOS__
#ifndef SYSTEM_PRIVATE
#define SYSTEM_PRIVATE
#endif
#include <libraries/query.h>
#endif

#define __READONLY__ __attribute__ ((section (".rodata")))
#if __GNUC__ > 2
#define __USED__ __attribute__ ((used))
#else
#define __USED__
#endif

#ifdef __MORPHOS__
const unsigned long __abox__ __READONLY__ = 1;

/*
 * Needed for ObjData to load it at all..
 * as it needs a Programsegment
 */
int main(void)
{
	return(0);
}
#endif

#ifdef QUERYINFOATTR_NAME
static const struct TagItem QueryTags[] __READONLY__ =
{
	{QUERYINFOATTR_NAME, (ULONG) KMNAME},
	{QUERYINFOATTR_IDSTRING, (ULONG) KMID},
	{QUERYINFOATTR_DESCRIPTION, (ULONG) KMDESC},
	#ifdef VERSION
	{QUERYINFOATTR_VERSION, (ULONG) VERSION},
	#endif
	#ifdef REVISION
	{QUERYINFOATTR_REVISION, REVISION},
	#endif
	{QUERYINFOATTR_TYPE, QUERYTYPE_NONE},
	{QUERYINFOATTR_SUBTYPE, QUERYSUBTYPE_KEYMAP},
	{QUERYINFOATTR_LANG_LANGUAGE,(ULONG)KMLANG},
	{QUERYINFOATTR_LANG_LANGUAGE_INT,(ULONG)KMLANGINT},
	{QUERYINFOATTR_LANG_CODEPAGE,(ULONG)KMCODEPAGE},
	#if HAVE_UNICODE_CONVTABLE
	{QUERYINFOATTR_CUSTOM_KEYMAP_UNICODECONVTABLE,(ULONG)&convtable},
	#endif
	#if HAVE_CHARSET_CONVTABLE
	{QUERYINFOATTR_CUSTOM_KEYMAP_CHARSETCONVTABLE,(ULONG)&convtable2},
	#endif
	{TAG_DONE,0}
};
#endif

static const struct Resident ROMTag __READONLY__ __USED__ =
{
	RTC_MATCHWORD,
	(struct Resident *) &ROMTag,
	(struct Resident *) (&ROMTag + 1),
#ifdef __MORPHOS__
	0 | RTF_EXTENDED,		// flags
#else
	0,				// flags
#endif
	VERSION,			// version
	NT_UNKNOWN,			// type
	0,				// pri
	(STRPTR) keymapname,		// name
	KMID,				// idstring
	(APTR) &km			// init

#ifdef __MORPHOS__
	/* RTF_EXTENDED Fields */
	,REVISION,			// revision
#ifdef QUERYINFOATTR_NAME		// tags
	(struct TagItem *) QueryTags
#else
	NULL
#endif
#endif /* __MORPHOS__ */
};
